local assets=
{ 
    Asset("ANIM", "anim/hat_paranoid.zip"),
    Asset("ANIM", "anim/hat_paranoid_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/hat_paranoid.xml"),
    Asset("IMAGE", "images/inventoryimages/hat_paranoid.tex"),
}

local prefabs = 
{
}

local function fn()

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_paranoid_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        print('A')
        if owner:HasTag("player") then
            print('B')
            owner.AnimState:Hide("HEAD")
            owner.AnimState:Show("HEAD_HAIR")
        end
        owner:AddTag("trigger_paranoia")
        owner:PushEvent("formchange")
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
		owner:RemoveTag("trigger_paranoia")
        owner:PushEvent("formchange")
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("hat_bee_bw")
    anim:SetBuild("hat_paranoid")
    anim:PlayAnimation("idle")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "hat_paranoid"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_paranoid.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    return inst
end

return  Prefab("common/inventory/hat_paranoid", fn, assets, prefabs)